package cn.com.duibaboot.ext.autoconfigure.monitor.cache;

import cn.com.duiba.boot.utils.RequestUtils;
import com.alibaba.fastjson.JSON;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

import javax.servlet.*;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

/**
 * @author: <a href="http://www.panaihua.com">panaihua</a>
 * @date: 2019-07-22 19:41
 * @descript: 缓存状态拦截: /monitor/cache/all 获取所有缓存
 * @version: 1.0
 */
public class CacheMonitorFilter implements Filter {
    @Override
    public void init(FilterConfig filterConfig) throws ServletException {
        //do nothing
    }

    @Override
    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain chain) throws IOException, ServletException {

        HttpServletRequest request = (HttpServletRequest) servletRequest;
        HttpServletResponse response = (HttpServletResponse) servletResponse;
        String requestPath = RequestUtils.getRequestPath(request);
        if (requestPath.equals("/monitor/cache/all")) {

            Set<String> allCaches = CacheMonitorManager.getAllCache();
            response.getWriter().write(JSON.toJSONString(allCaches));
        } else if (requestPath.equals("/monitor/cache/query")) {
            response.getWriter().write(this.doQuery(servletRequest));
        } else if (requestPath.equals("/monitor/cache/record")) {
            response.getWriter().write(this.doRecord(servletRequest));
        } else {
            chain.doFilter(servletRequest, servletResponse);
        }

    }

    /**
     * 处理key查询
     *
     * @param servletRequest
     * @return
     */
    private String doQuery(ServletRequest servletRequest) {

        String key = servletRequest.getParameter("key");
        String cacheName = servletRequest.getParameter("cacheName");
        if (StringUtils.isBlank(key) || StringUtils.isBlank(cacheName)) {
            return "";
        }

        Object value = CacheMonitorManager.getCacheValueByKey(cacheName, key);
        return JSON.toJSONString(value);
    }

    /**
     * 处理key查询
     *
     * @param servletRequest
     * @return
     */
    private String doRecord(ServletRequest servletRequest) {

        String key = servletRequest.getParameter("key");
        String cacheName = servletRequest.getParameter("cacheName");
        String pageSize = servletRequest.getParameter("pageSize");
        String page = servletRequest.getParameter("page");

        if(StringUtils.isBlank(pageSize)) {
            pageSize = "10";
        }

        if(StringUtils.isBlank(page)) {
            page = "1";
        }

        RecordPagerResponse<CacheChangeRecord> records = CacheMonitorManager.getRecord(cacheName, key, Integer.parseInt(pageSize), Integer.parseInt(page));
        if (records == null) {
            return "";
        }

        return JSON.toJSONString(records);
    }

    @Override
    public void destroy() {
        //do nothing
    }
}
