package cn.com.duibaboot.ext.autoconfigure.zuul;

import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurerAdapter;

import javax.servlet.Servlet;

/**
 *  如果识别到X-Via-Zuul: true的http请求头，表示请求来自zuul，则在http响应头里增加X-Match-Path：输出，表示匹配到的uri，zuul可以拿到此uri并记录到cat。这样可以防止zuul记录/stock/1,/stock/2等uri.
 */
@Configuration
@ConditionalOnWebApplication
public class DuibaZuulAutoConfiguration {

    public static final String X_VIA_ZUUL = "X-Via-Zuul";
    public static final String X_MATCH_PATH = "X-Match-Path";

    @Configuration
    @ConditionalOnClass({Servlet.class, InterceptorRegistry.class})
    @ConditionalOnWebApplication
    public static class DuibaHandlerInterceptorConfiguration extends WebMvcConfigurerAdapter {

        @Override
        public void addInterceptors(InterceptorRegistry registry) {
            registry.addInterceptor(new DuibaZuulHandlerInterceptor());

            super.addInterceptors(registry);
        }
    }

}
