package cn.com.duibaboot.ext.autoconfigure.flowreplay;

import cn.com.duiba.wolf.utils.UUIDUtils;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.serializer.KryoSerializer;
import org.aspectj.lang.reflect.MethodSignature;

import java.lang.reflect.Method;

/**
 * 自定义的span类型。
 * Created by guoyanfei .
 * 2019-05-23 .
 */
public class CustomizeFlowReplaySpan extends FlowReplaySpan {

    private static final long serialVersionUID = -3405806286282172905L;

    /**
     * 方法名称
     */
    private String methodName;

    /**
     * 参数类型数组
     */
    private String[] parameterTypes;

    /**
     * 参数值数组
     */
    private byte[] parameterValues;

    /**
     * 返回值类型
     */
    private String returnType;

    /**
     * 返回值
     */
    private byte[] returnValue;

    /**
     * 所在类，全路径，例如：cn.com.duiba.message.service.remoteservice.RemoteSmsServiceImpl
     */
    private String typeFullPath;

    @Override
    public SpanType getSpanType() {
        return SpanType.CUSTOMIZE;
    }

    /**
     * 创建span
     * @param method
     * @param allArguments
     * @param argumentsTypes
     * @param ret
     * @return
     */
    public static CustomizeFlowReplaySpan createSpan(MethodSignature methodSignature, Object[] parameterValues, Object ret) {
        Method method = methodSignature.getMethod();
        Class<?>[] parameterTypes = method.getParameterTypes();
        String[] parameterTypeNames = null;
        if (parameterTypes.length > 0) {
            parameterTypeNames = new String[parameterTypes.length];
            for (int i = 0; i < parameterTypes.length; i++) {
                parameterTypeNames[i] = parameterTypes[i].getName();
            }
        }
        Class returnTypeClass = methodSignature.getReturnType();

        CustomizeFlowReplaySpan span = new CustomizeFlowReplaySpan();
        span.setSpanId(UUIDUtils.createUUID());
        span.methodName = method.getName();
        span.parameterTypes = parameterTypeNames;
        span.parameterValues = KryoSerializer.serialize(parameterValues);
        span.returnType = returnTypeClass != null ? returnTypeClass.getName() : null;
        span.returnValue = KryoSerializer.serialize(ret);
        span.typeFullPath = methodSignature.getDeclaringTypeName();
        return span;
    }

    public String getMethodName() {
        return methodName;
    }

    public String[] getParameterTypes() {
        return parameterTypes;
    }

    public Object[] getParameterValues() {
        return (Object[]) KryoSerializer.deserialize(parameterValues);
    }

    public Object getReturnValue() {
        return KryoSerializer.deserialize(returnValue);
    }

    public String getReturnType() {
        return returnType;
    }

    public String getTypeFullPath() {
        return typeFullPath;
    }
}
