package cn.com.duibaboot.ext.autoconfigure.flowreplay.replay.aop;

import cn.com.duiba.boot.flowreplay.FlowReplayCustomizeSpan;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.*;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.replay.ReplayTraceContext;
import com.esotericsoftware.kryo.KryoException;
import lombok.extern.slf4j.Slf4j;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;

import java.lang.reflect.Method;

/**
 * FlowReplayCustomizeSpan 注解切面，用于实际的回放
 * Created by guoyanfei .
 * 2019-05-23 .
 */
@Slf4j
@Aspect
public class ReplayCustomizeFlowReplaySpanPlugin {

    @Around("execution(* *.*(..)) && @annotation(cn.com.duiba.boot.flowreplay.FlowReplayCustomizeSpan)")
    public Object customizeJoinPoint(ProceedingJoinPoint joinPoint) throws Throwable {
        MethodSignature signature = (MethodSignature) joinPoint.getSignature();
        FlowReplayCustomizeSpan customizeSpanAnno = signature.getMethod().getAnnotation(FlowReplayCustomizeSpan.class);
        if (customizeSpanAnno == null) {
            return joinPoint.proceed();
        }
        // 当前不是回放的环境 或者 当前请求不是回放请求
        if (!FlowReplayUtils.isReplayEnv() || !ReplayTraceContext.isReplaying()) {
            return joinPoint.proceed();
        }

        FlowReplaySpan span = ReplayTraceContext.pollSubSpan();

        log.debug("Customize回放_traceId={}_spanType={}_spanId={}", ReplayTraceContext.getContextTraceId(), span != null ? span.getSpanType() : null, span != null ? span.getSpanId() : null);

        // 增加了新的调用 || 调用内容有变动
        if (span == null || SpanType.CUSTOMIZE != span.getSpanType()) {
            String expert = SpanType.CUSTOMIZE.name();
            String actual = span != null ? span.getSpanType().name() : null;
            ReplayTraceContext.markError(FlowReplayErrorMsgTypeEnum.EM_001, expert, actual);
            throw new FlowReplayException(ReplayTraceContext.getCompletedErrorMsg());
        }

        CustomizeFlowReplaySpan customizeSpan = (CustomizeFlowReplaySpan) span;

        Method method = signature.getMethod();
        Object[] parameterValues = joinPoint.getArgs();

        // 方法名是否相同
        if (!FlowReplayUtils.isMethodEqual(customizeSpan.getMethodName(), method)) {
            String expert = customizeSpan.getMethodName();
            String actual = method.getName();
            ReplayTraceContext.markError(FlowReplayErrorMsgTypeEnum.EM_701, expert, actual);
            throw new FlowReplayException(ReplayTraceContext.getCompletedErrorMsg());
        }

        // 参数类型是否相同
        if (!FlowReplayUtils.isArgumentsTypesEqual(customizeSpan.getParameterTypes(), method.getParameterTypes())) {
            String expert = FlowReplayUtils.stringArrayToString(customizeSpan.getParameterTypes());
            String actual = FlowReplayUtils.classArrayToString(method.getParameterTypes());
            ReplayTraceContext.markError(FlowReplayErrorMsgTypeEnum.EM_702, expert, actual);
            throw new FlowReplayException(ReplayTraceContext.getCompletedErrorMsg());
        }

        try {
            // 参数值是否相同
            if (!FlowReplayUtils.isArgumentsEqual(customizeSpan.getParameterValues(), parameterValues)) {
                ReplayTraceContext.markError(FlowReplayErrorMsgTypeEnum.EM_703);
                throw new FlowReplayException(ReplayTraceContext.getCompletedErrorMsg());
            }
        } catch (KryoException e) {
            ReplayTraceContext.markError(FlowReplayErrorMsgTypeEnum.EM_706, e);
            throw new FlowReplayException(ReplayTraceContext.getCompletedErrorMsg());
        }

        // 返回值类型是否相同
        if (!FlowReplayUtils.isReturnTypeEqual(customizeSpan.getReturnType(), method.getReturnType())) {
            String expert = customizeSpan.getReturnType();
            String actual = method.getReturnType() != null ? method.getReturnType().getName() : null;
            ReplayTraceContext.markError(FlowReplayErrorMsgTypeEnum.EM_704, expert, actual);
            throw new FlowReplayException(ReplayTraceContext.getCompletedErrorMsg());
        }

        // 方法所在类全路径是否相同
        if (!FlowReplayUtils.isTypeFullPathEqual(customizeSpan.getTypeFullPath(), signature.getDeclaringTypeName())) {
            String expert = customizeSpan.getTypeFullPath();
            String actual = signature.getDeclaringTypeName();
            ReplayTraceContext.markError(FlowReplayErrorMsgTypeEnum.EM_705, expert, actual);
            throw new FlowReplayException(ReplayTraceContext.getCompletedErrorMsg());
        }

        try {
            // 都相同mock返回值
            return customizeSpan.getReturnValue();
        } catch (KryoException e) {
            ReplayTraceContext.markError(FlowReplayErrorMsgTypeEnum.EM_707, e);
            throw new FlowReplayException(ReplayTraceContext.getCompletedErrorMsg());
        }
    }
}
