package cn.com.duibaboot.ext.autoconfigure.flowreplay.replay.endpoint;

import cn.com.duibaboot.ext.autoconfigure.flowreplay.FlowReplayException;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.FlowReplayUtils;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.JsonResult;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.replay.ReplayContextHolder;
import lombok.extern.slf4j.Slf4j;
import org.springframework.boot.actuate.endpoint.mvc.AbstractNamedMvcEndpoint;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

/**
 * 流量回放终止端点
 * Created by guoyanfei .
 * 2019-02-19 .
 */
@Slf4j
public class ReplayStopMvcEndpoint extends AbstractNamedMvcEndpoint {

    public ReplayStopMvcEndpoint() {
        super("flow/replay/stop", "/flow/replay/stop", true);
    }

    @ResponseBody
    @RequestMapping(method = RequestMethod.POST)
    public String invoke() {
        JsonResult<String> result;
        try {
            if (!FlowReplayUtils.isReplayEnv()) {
                throw new FlowReplayException("当前服务非回放专用服务，无法进行回放相关操作");
            }
            ReplayContextHolder.forceEnd();
            result = JsonResult.successResult("ok");
        } catch (FlowReplayException e) {
            result = JsonResult.failedResult(e.getMessage());
        } catch (Exception e) {
            log.error("回放stop异常", e);
            result = JsonResult.failedResult(e.getMessage());
        }
        return result.toJSONString();
    }

}
