package cn.com.duibaboot.ext.autoconfigure.grouping;

import com.alibaba.ttl.TransmittableThreadLocal;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;

/**
 * 服务分组标识的上下文对象
 * 目前用于支持需求：http://cf.dui88.com/pages/viewpage.action?pageId=11134823
 * Created by guoyanfei .
 * 2018/11/7 .
 */
@Slf4j
public final class ServiceGroupContext {

    private ServiceGroupContext() {
    }

    /**
     * 当前请求上下文的分组标识
     */
    private String duibaServiceGroupKey;

    private static class TransmittableThreadLocalHolder {

        private TransmittableThreadLocalHolder() {
        }

        protected static final TransmittableThreadLocal<ServiceGroupContext> threadLocal2ServiceGroup = new TransmittableThreadLocal<ServiceGroupContext>();
    }

    /**
     * 获取当前分组标识
     * @return
     */
    public static String getCurrentGroupKey() {
        ServiceGroupContext c = TransmittableThreadLocalHolder.threadLocal2ServiceGroup.get();
        if (c == null) {
            return null;
        }
        return c.duibaServiceGroupKey;
    }

    /**
     * 设置分组标识
     * 注意：除非特殊情况，否则框架使用者不应该调用此方法
     * @param groupKey
     */
    public static void setGroupKey(String groupKey) {
        if (StringUtils.isBlank(groupKey)) {
            return;
        }
        ServiceGroupContext c = TransmittableThreadLocalHolder.threadLocal2ServiceGroup.get();
        if (c == null) {
            c = new ServiceGroupContext();
        }
        c.duibaServiceGroupKey = groupKey;
        TransmittableThreadLocalHolder.threadLocal2ServiceGroup.set(c);
    }

    /**
     * 清除分组标识
     * 注意：除非特殊情况，否则框架使用者不应该调用此方法
     */
    public static void removeGroupKey() {
        TransmittableThreadLocalHolder.threadLocal2ServiceGroup.remove();
    }
}
