package cn.com.duibaboot.ext.autoconfigure.monitor.cache;

import cn.com.duibaboot.ext.autoconfigure.javaagent.core.interceptor.enhance.InstanceMethodsAroundInterceptor;
import cn.com.duibaboot.ext.autoconfigure.javaagent.core.interceptor.enhance.MethodInterceptResult;
import com.alibaba.fastjson.JSON;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.RemovalListener;
import com.google.common.cache.RemovalListeners;
import lombok.extern.slf4j.Slf4j;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Date;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

/**
 * @author: <a href="http://www.panaihua.com">panaihua</a>
 * @date: 2019-07-23 16:15
 * @descript:
 * @version: 1.0
 */
@Slf4j
public class CacheBuildInterceptor implements InstanceMethodsAroundInterceptor {

    private final ExecutorService executorService = Executors.newSingleThreadExecutor();

    @Override
    public void beforeMethod(Object obj, Method method, Object[] allArguments, Class<?>[] argumentsTypes, MethodInterceptResult result) throws Throwable {

        if (!"build".equals(method.getName())) {
            return;
        }

        try {

            if (obj instanceof CacheBuilder) {
                CacheBuilder cacheBuilder = (CacheBuilder) obj;
                cacheBuilder.recordStats();
                if(this.isAlreadSetRemoval(cacheBuilder)) {
                    return;
                }

                RemovalListener<Object, Object> removalListener = RemovalListeners.asynchronous((notification -> {

                    if (notification.getKey() == null) {
                        return;
                    }

                    CacheChangeRecord changeRecord = new CacheChangeRecord();
                    changeRecord.setExpireDate(new Date());
                    changeRecord.setKey(notification.getKey());
                    changeRecord.setExpireType(RemovalCauseUtil.getTypeByEnumName(notification.getCause().name()));
                    changeRecord.setValue(JSON.toJSONString(notification.getValue()));
                    changeRecord.setBuilderHashcode(cacheBuilder.hashCode());
                    CacheMonitorManager.addRecord(changeRecord);

                }), executorService);
                cacheBuilder.removalListener(removalListener);
            }

            if (obj instanceof Caffeine) {
                Caffeine caffeine = (Caffeine) obj;
                caffeine.recordStats();
                if(this.isAlreadSetRemoval(caffeine)) {
                    return;
                }

                caffeine.removalListener((key, value, cause) -> {// 与guava不同，默认就是异步
                    CacheChangeRecord changeRecord = new CacheChangeRecord();
                    changeRecord.setExpireDate(new Date());
                    changeRecord.setKey(key);
                    changeRecord.setExpireType(RemovalCauseUtil.getTypeByEnumName(cause.name()));
                    changeRecord.setValue(JSON.toJSONString(value));
                    changeRecord.setBuilderHashcode(caffeine.hashCode());
                    CacheMonitorManager.addRecord(changeRecord);
                });
            }

        } catch (Exception e) {
            log.error("cacheBuilder afterMethod excetion", e);
        }
    }

    @Override
    public Object afterMethod(Object zuperCall, Object obj, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Object ret) throws Throwable {

        CacheMonitorManager.setBuilderCache(obj.hashCode(), ret);
        return ret;
    }

    @Override
    public void handleMethodException(Object obj, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Throwable t) {
        log.error("CacheBuildInterceptor exception", t);
    }

    private boolean isAlreadSetRemoval(Object object) throws Exception {

        Field field = object.getClass().getDeclaredField("removalListener");
        field.setAccessible(true);
        boolean isRemoval = field.get(object) != null;
        field.setAccessible(false);
        return isRemoval;
    }
}
