package cn.com.duibaboot.ext.autoconfigure.flowreplay;

import cn.com.duiba.wolf.utils.UUIDUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.*;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpRequestWrapper;
import org.apache.http.util.EntityUtils;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLDecoder;
import java.util.*;

/**
 * Created by guoyanfei .
 * 2019-07-18 .
 */
public class HttpClientFlowReplaySpan extends FlowReplaySpan {

    private static final long serialVersionUID = -7977781583338574639L;

    private String method;

    private String url;

    private Map<String, String> requestHeaders;

    private Map<String, List<String>> requestParameters;

    private byte[] requestBody;

    private Map<String, String> responseHeaders;

    /** Name of the protocol. */
    private String protocol;

    /** Major version number of the protocol */
    private int major;

    /** Minor version number of the protocol */
    private int minor;

    private int statusCode;

    private String reasonPhrase;

    private byte[] responseBody;

    @Override
    public SpanType getSpanType() {
        return SpanType.HTTP_CLIENT;
    }

    /**
     * 创建span
     * @param httpRequestWrapper
     * @param response
     * @return
     * @throws IOException
     */
    public static HttpClientFlowReplaySpan createSpan(HttpRequestWrapper httpRequestWrapper, CloseableHttpResponse response) throws IOException {
        HttpClientFlowReplaySpan span = new HttpClientFlowReplaySpan();

        URI uri = httpRequestWrapper.getURI();

        span.setSpanId(UUIDUtils.createUUID());
        // request
        span.method = httpRequestWrapper.getMethod();
        span.url = parseUrl(uri);
        span.requestHeaders = parseRequestHeaders(httpRequestWrapper);  // 目前该参数不参与回放的对比
        span.requestParameters = parseRequestParameters(uri);
        span.requestBody = parseRequestBody(httpRequestWrapper);

        // response
        StatusLine statusLine = response.getStatusLine();
        ProtocolVersion protocolVersion = statusLine.getProtocolVersion();
        span.responseHeaders = parseResponseHeaders(response.getAllHeaders());
        span.protocol = protocolVersion.getProtocol();
        span.major = protocolVersion.getMajor();
        span.minor = protocolVersion.getMinor();
        span.statusCode = statusLine.getStatusCode();
        span.reasonPhrase = statusLine.getReasonPhrase();
        span.responseBody = EntityUtils.toByteArray(response.getEntity());

        return span;
    }

    public static Map<String, String> parseResponseHeaders(Header[] allHeaders) {
        Map<String, String> headers = new LinkedHashMap<>();
        if (allHeaders != null && allHeaders.length > 0) {
            for (Header h : allHeaders) {
                headers.put(h.getName(), h.getValue());
            }
        }
        return headers;
    }


    public static Map<String, String> parseRequestHeaders(HttpRequestWrapper httpRequestWrapper) {
        Map<String, String> headers = new LinkedHashMap<>();
        Header[] headergroup = httpRequestWrapper.getAllHeaders();
        if (headergroup != null && headergroup.length > 0) {
            for (Header h : headergroup) {
                headers.put(h.getName(), h.getValue());
            }
        }
        return headers;
    }

    public static byte[] parseRequestBody(HttpRequestWrapper httpRequestWrapper) throws IOException {
        byte[] requestBody = null;
        HttpRequest httpRequest = httpRequestWrapper.getOriginal();
        if (httpRequest instanceof HttpEntityEnclosingRequest) {
            HttpEntityEnclosingRequest entityEnclosingRequest = (HttpEntityEnclosingRequest) httpRequest;
            requestBody = EntityUtils.toByteArray(entityEnclosingRequest.getEntity());
        }
        return requestBody;
    }

    public static String parseUrl(URI uri) {
        if (uri == null) {
            return null;
        }
        String uriStr = uri.toString();
        if (uriStr.contains("?")) {
            uriStr = uriStr.substring(0, uriStr.indexOf("?"));
        }
        if (!uriStr.endsWith("/")) {
            uriStr = uriStr + "/";
        }
        return uriStr;
    }

    public static Map<String, List<String>> parseRequestParameters(URI uri) throws UnsupportedEncodingException {
        Map<String, List<String>> parameter = new HashMap<>();
        if (uri == null) {
            return parameter;
        }
        String query = uri.getQuery();
        if (StringUtils.isBlank(query)) {
            return parameter;
        }
        for (String param : query.split("&")) {
            String[] pair = param.split("=");
            String key = URLDecoder.decode(pair[0], "UTF-8");
            String value = "";
            if (pair.length > 1) {
                value = URLDecoder.decode(pair[1], "UTF-8");
            }

            List<String> values = parameter.computeIfAbsent(key, k -> new ArrayList<>());
            values.add(value);
        }
        return parameter;
    }

    public String getMethod() {
        return method;
    }

    public String getUrl() {
        return url;
    }

    public Map<String, String> getRequestHeaders() {
        return requestHeaders;
    }

    public Map<String, List<String>> getRequestParameters() {
        return requestParameters;
    }

    public byte[] getRequestBody() {
        return requestBody;
    }

    public Map<String, String> getResponseHeaders() {
        return responseHeaders;
    }

    public String getProtocol() {
        return protocol;
    }

    public int getMajor() {
        return major;
    }

    public int getMinor() {
        return minor;
    }

    public int getStatusCode() {
        return statusCode;
    }

    public String getReasonPhrase() {
        return reasonPhrase;
    }

    public byte[] getResponseBody() {
        return responseBody;
    }
}
