package cn.com.duibaboot.ext.autoconfigure.hazelcast;


import com.hazelcast.cluster.ClusterState;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.Member;
import com.hazelcast.version.Version;
import lombok.Builder;
import lombok.Getter;
import lombok.Setter;

import org.springframework.beans.factory.ObjectFactory;
import org.springframework.boot.actuate.endpoint.AbstractEndpoint;

import java.util.Set;
import javax.annotation.Resource;

/**
 * endpoint,可供查看hazelcast的集群状态、版本、集群成员等信息
 */
public class HazelcastEndpoint extends AbstractEndpoint<HazelcastEndpoint.HazelcastInfo> {

    // Use ObjectFactory to break cycle references
    @Resource
    private ObjectFactory<HazelcastInstance> hazelcastInstanceObjectFactory;

    private volatile HazelcastInstance hazelcastInstance;

    public HazelcastEndpoint() {
        super("hazelcast", true, true);
    }

    @Override
    public HazelcastEndpoint.HazelcastInfo invoke() {
        return HazelcastInfo.builder()
                .clusterVersion(getHazelcastInstance().getCluster().getClusterVersion())
                .clusterState(getHazelcastInstance().getCluster().getClusterState())
                .members(getHazelcastInstance().getCluster().getMembers())
                .build();
    }

    public HazelcastInstance getHazelcastInstance(){
        if (hazelcastInstance == null) {
            hazelcastInstance = hazelcastInstanceObjectFactory.getObject();
        }

        return hazelcastInstance;
    }

    @Getter
    @Setter
    @Builder
    static class HazelcastInfo{
        private Version clusterVersion;
        private ClusterState clusterState;
        private Set<Member> members;
    }
}
