package cn.com.duibaboot.ext.autoconfigure.monitor.cache;

import cn.com.duibaboot.ext.autoconfigure.javaagent.core.interceptor.enhance.InstanceMethodsAroundInterceptor;
import cn.com.duibaboot.ext.autoconfigure.javaagent.core.interceptor.enhance.MethodInterceptResult;
import com.alibaba.fastjson.JSON;
import com.github.benmanes.caffeine.cache.Caffeine;
import lombok.extern.slf4j.Slf4j;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Date;

/**
 * @author: <a href="http://www.panaihua.com">panaihua</a>
 * @date: 2019-07-23 16:15
 * @descript:
 * @version: 1.0
 */
@Slf4j
public class CaffeineCacheBuildInterceptor implements InstanceMethodsAroundInterceptor {

    @Override
    public void beforeMethod(Object obj, Method method, Object[] allArguments, Class<?>[] argumentsTypes, MethodInterceptResult result) throws Throwable {

        if (!"build".equals(method.getName()) && !"buildAsync".equals(method.getName())) {
            return;
        }

        try {

            Caffeine caffeine = (Caffeine) obj;
            if (!this.isAlreadSetRecord(caffeine)) {
                caffeine.recordStats();
            }

            if (this.isAlreadSetRemoval(caffeine)) {
                return;
            }


            int hashcode = System.identityHashCode(caffeine);
            caffeine.removalListener((key, value, cause) -> {// 与guava不同，默认就是异步
                CacheChangeRecord changeRecord = new CacheChangeRecord();
                changeRecord.setExpireDate(new Date());
                changeRecord.setKey(key);
                changeRecord.setExpireType(RemovalCauseUtil.getTypeByEnumName(cause.name()));
                changeRecord.setValue(JSON.toJSONString(value));
                changeRecord.setBuilderHashcode(hashcode);
                CacheMonitorManager.addRecord(changeRecord);
            });

        } catch (Exception e) {
            log.error("cacheBuilder afterMethod excetion", e);
        }
    }

    @Override
    public Object afterMethod(Object zuperCall, Object obj, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Object ret) throws Throwable {

        CacheMonitorManager.setBuilderCache(System.identityHashCode(obj), ret);
        return ret;
    }

    @Override
    public void handleMethodException(Object obj, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Throwable t) {
        // do nothing
    }

    private boolean isAlreadSetRemoval(Object object) throws Exception {

        Field field = object.getClass().getDeclaredField("removalListener");
        field.setAccessible(true);
        boolean isRemoval = field.get(object) != null;
        field.setAccessible(false);
        return isRemoval;
    }

    private boolean isAlreadSetRecord(Object object) throws Exception {

        Field field = object.getClass().getDeclaredField("statsCounterSupplier");
        field.setAccessible(true);
        boolean isRecord = field.get(object) != null;
        field.setAccessible(false);
        return isRecord;
    }
}
