package cn.com.duibaboot.ext.autoconfigure.profiler;

import cn.com.duiba.boot.profiler.DBTimeProfiler;
import cn.com.duiba.wolf.perf.timeprofile.DBTimeProfile;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;

@Aspect
public class TimeProfileAspect {

    @Around("execution(* *.*(..)) && @annotation(cn.com.duiba.boot.profiler.DBTimeProfiler)")
    public Object catTransactionAspect(ProceedingJoinPoint joinPoint) throws Throwable{
        MethodSignature signature = (MethodSignature) joinPoint.getSignature();
        DBTimeProfiler timeProfiler = signature.getMethod().getAnnotation(DBTimeProfiler.class);
        if(timeProfiler == null){
            return joinPoint.proceed();
        }
		String methodName = signature.getMethod().getName();
        DBTimeProfile.enter(signature.getMethod().getDeclaringClass().getSimpleName() + "." + methodName);

        try{
            return joinPoint.proceed();
        }finally{
            DBTimeProfile.release();
        }
    }

}
