package cn.com.duibaboot.ext.autoconfigure.security;

import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(prefix = "duiba.securitymanager")
public class SecurityProperties {
    /**
     * 是否启用安全管理器SecurityManager,默认启用
     */
    private Boolean enable = true;

    /**
     * 允许执行的shell白名单，多个用逗号隔开，sh/bash/exec/fork等通用命令会被忽略
     */
    private String whiteShellList;

    public boolean isEnable() {
        return enable;
    }

    public void setEnable(boolean enable) {
        this.enable = enable;
    }

    public String getWhiteShellList() {
        return whiteShellList;
    }

    public void setWhiteShellList(String whiteShellList) {
        this.whiteShellList = whiteShellList;
    }
}
