package cn.com.duibaboot.ext.autoconfigure.elasticjob;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import com.dangdang.ddframe.job.lite.internal.monitor.MonitorService;
import com.dangdang.ddframe.job.lite.internal.schedule.JobRegistry;
import com.dangdang.ddframe.job.reg.base.CoordinatorRegistryCenter;
import com.google.common.base.Joiner;

import org.springframework.boot.actuate.endpoint.AbstractEndpoint;
import org.springframework.util.ReflectionUtils;

/**
 * 查看elastic-job的监控数据
 */
public class ElasticJobMonitorEndpointV2 extends AbstractEndpoint<String> {

    public ElasticJobMonitorEndpointV2() {
        super("elasticJobMonitor");
    }

    @Override
    public String invoke() {
        return genFromElasticJob2();
    }

    public String genFromElasticJob2(){
        JobRegistry jobRegistry = JobRegistry.getInstance();
        Field regCenterMapField = ReflectionUtils.findField(jobRegistry.getClass(), "regCenterMap");
        regCenterMapField.setAccessible(true);
        Map<String, CoordinatorRegistryCenter> regCenterMap = (Map<String, CoordinatorRegistryCenter>)ReflectionUtils.getField(regCenterMapField, jobRegistry);

        Method dumpDirectlyMethod = ReflectionUtils.findMethod(MonitorService.class, "dumpDirectly", String.class, List.class);
        dumpDirectlyMethod.setAccessible(true);
        final StringBuilder sb = new StringBuilder();
        regCenterMap.forEach((jobName, regCenter) -> {
            MonitorService ms = new MonitorService(regCenter, jobName);
            List<String> result = new ArrayList<>();
            ReflectionUtils.invokeMethod(dumpDirectlyMethod, ms, "/" + jobName, result);
            String jobMonitorData = Joiner.on("\n").join(result);

            sb.append("----").append("jobName:").append(jobName).append("----\n").append(jobMonitorData).append("\n");
        });

        return sb.toString();
    }
}
