package cn.com.duibaboot.ext.autoconfigure.flowreplay.record.endpoint;

import cn.com.duibaboot.ext.autoconfigure.flowreplay.JsonResult;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.record.RecordContextHolder;
import org.springframework.boot.actuate.endpoint.mvc.AbstractNamedMvcEndpoint;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

/**
 * 流量录制结束
 * Created by guoyanfei .
 * 2019-02-19 .
 */
public class RecordStopMvcEndpoint extends AbstractNamedMvcEndpoint {

    public RecordStopMvcEndpoint() {
        super("flow/record/stop", "/flow/record/stop", true);
    }

    @ResponseBody
    @RequestMapping(method = RequestMethod.POST)
    public String invoke() {
        JsonResult<String> result;
        try {
            // 结束录制
            RecordContextHolder.abnormalEnd("手动停止");
            result = JsonResult.successResult("ok");
        } catch (Exception e) {
            result = JsonResult.failedResult(e.getMessage());
        }
        return result.toJSONString();
    }

}
