package cn.com.duibaboot.ext.autoconfigure.cat;

import javax.annotation.Resource;
import javax.servlet.Servlet;

import com.dianping.cat.Cat;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.core.Ordered;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

/**
 * 使用cat rpc interceptor,拦截来自FeignClient的Http Rest Rpc调用并加入cat监控
 * Created by wenqi.huang on 16/8/17.
 */
@Configuration
@ConditionalOnClass({Servlet.class, Cat.class, FeignClient.class})
@ConditionalOnWebApplication(type = ConditionalOnWebApplication.Type.SERVLET)
@Import(CatRpcHandlerInterceptor.class)
public class SpringMvcConfigForCat {//WebMvcConfigurationSupport

    @Bean
    public SpringMvcConfigurerForCat springMvcConfigurerForCat(){
        return new SpringMvcConfigurerForCat();
    }

    static class SpringMvcConfigurerForCat implements WebMvcConfigurer,Ordered{

        @Resource
        private CatRpcHandlerInterceptor catRpcHandlerInterceptor;

        @Override
        public void addInterceptors(InterceptorRegistry registry) {
            registry.addInterceptor(catRpcHandlerInterceptor).addPathPatterns("/**");
        }

        @Override
        public int getOrder() {
            return -100;
        }

    }
}
