package cn.com.duibaboot.ext.autoconfigure.datasource.encrypt.swapper;

import cn.com.duibaboot.ext.autoconfigure.datasource.encrypt.config.DuibaEncryptColumnRuleProperties;
import org.apache.shardingsphere.encrypt.api.EncryptColumnRuleConfiguration;

public final class DuibaEncryptColumnRuleConfigurationPropSwapper implements PropSwapper<DuibaEncryptColumnRuleProperties, EncryptColumnRuleConfiguration> {

    @Override
    public DuibaEncryptColumnRuleProperties swap(final EncryptColumnRuleConfiguration data) {
        DuibaEncryptColumnRuleProperties result = new DuibaEncryptColumnRuleProperties();
        result.setPlainColumn(data.getPlainColumn());
        result.setCipherColumn(data.getCipherColumn());
        result.setAssistedQueryColumn(data.getAssistedQueryColumn());
        result.setEncryptor(data.getEncryptor());
        return result;
    }

    @Override
    public EncryptColumnRuleConfiguration swap(final DuibaEncryptColumnRuleProperties encryptColumnRuleProp) {
        return new EncryptColumnRuleConfiguration(encryptColumnRuleProp.getPlainColumn(), encryptColumnRuleProp.getCipherColumn(), encryptColumnRuleProp.getAssistedQueryColumn(), encryptColumnRuleProp.getEncryptor());
    }
}
