package cn.com.duibaboot.ext.autoconfigure.datasource.encrypt.swapper;

import cn.com.duibaboot.ext.autoconfigure.datasource.encrypt.config.DuibaEncryptRuleProperties;
import com.google.common.collect.Maps;
import org.apache.shardingsphere.encrypt.api.EncryptRuleConfiguration;

public final class DuibaEncryptRuleConfigurationPropSwapper implements PropSwapper<DuibaEncryptRuleProperties, EncryptRuleConfiguration> {
    
    private final DuibaEncryptorRuleConfigurationPropSwapper duibaEncryptorRuleConfigurationPropSwapper = new DuibaEncryptorRuleConfigurationPropSwapper();
    
    private final DuibaEncryptTableRuleConfigurationPropSwapper encryptTableRuleConfigurationYamlSwapper = new DuibaEncryptTableRuleConfigurationPropSwapper();
    
    @Override
    public DuibaEncryptRuleProperties swap(final EncryptRuleConfiguration data) {
        DuibaEncryptRuleProperties result = new DuibaEncryptRuleProperties();
        result.getEncryptors().putAll(Maps.transformValues(data.getEncryptors(), duibaEncryptorRuleConfigurationPropSwapper::swap));
        result.getTables().putAll(Maps.transformValues(data.getTables(), encryptTableRuleConfigurationYamlSwapper::swap));
        return result;
    }
    
    @Override
    public EncryptRuleConfiguration swap(final DuibaEncryptRuleProperties encryptRuleProp) {
        EncryptRuleConfiguration result = new EncryptRuleConfiguration();
        result.getEncryptors().putAll(Maps.transformValues(encryptRuleProp.getEncryptors(), duibaEncryptorRuleConfigurationPropSwapper::swap));
        result.getTables().putAll(Maps.transformValues(encryptRuleProp.getTables(), encryptTableRuleConfigurationYamlSwapper::swap));
        return result;
    }
}
