package cn.com.duibaboot.ext.autoconfigure.datasource.encrypt.swapper;

import cn.com.duibaboot.ext.autoconfigure.datasource.encrypt.config.DuibaEncryptColumnRuleProperties;
import cn.com.duibaboot.ext.autoconfigure.datasource.encrypt.config.DuibaEncryptTableRuleProperties;
import org.apache.shardingsphere.encrypt.api.EncryptColumnRuleConfiguration;
import org.apache.shardingsphere.encrypt.api.EncryptTableRuleConfiguration;

import java.util.Map;

public final class DuibaEncryptTableRuleConfigurationPropSwapper implements PropSwapper<DuibaEncryptTableRuleProperties, EncryptTableRuleConfiguration> {

    private final DuibaEncryptColumnRuleConfigurationPropSwapper duibaEncryptColumnRuleConfigurationPropSwapper = new DuibaEncryptColumnRuleConfigurationPropSwapper();

    @Override
    public DuibaEncryptTableRuleProperties swap(final EncryptTableRuleConfiguration data) {
        DuibaEncryptTableRuleProperties result = new DuibaEncryptTableRuleProperties();
        for (Map.Entry<String, EncryptColumnRuleConfiguration> entry : data.getColumns().entrySet()) {
            result.getColumns().put(entry.getKey(), duibaEncryptColumnRuleConfigurationPropSwapper.swap(entry.getValue()));
        }
        return result;
    }

    @Override
    public EncryptTableRuleConfiguration swap(final DuibaEncryptTableRuleProperties encryptTableRuleProp) {
        EncryptTableRuleConfiguration result = new EncryptTableRuleConfiguration();
        for (Map.Entry<String, DuibaEncryptColumnRuleProperties> entry : encryptTableRuleProp.getColumns().entrySet()) {
            result.getColumns().put(entry.getKey(), duibaEncryptColumnRuleConfigurationPropSwapper.swap(entry.getValue()));
        }
        return result;
    }
}
