package cn.com.duibaboot.ext.autoconfigure.datasource.encrypt.swapper;

import cn.com.duibaboot.ext.autoconfigure.datasource.encrypt.config.DuibaEncryptorRuleProperties;
import org.apache.shardingsphere.encrypt.api.EncryptorRuleConfiguration;

public final class DuibaEncryptorRuleConfigurationPropSwapper implements PropSwapper<DuibaEncryptorRuleProperties, EncryptorRuleConfiguration> {
    
    @Override
    public DuibaEncryptorRuleProperties swap(final EncryptorRuleConfiguration data) {
        DuibaEncryptorRuleProperties result = new DuibaEncryptorRuleProperties();
        result.setType(data.getType());
        result.setProps(data.getProperties());
        return result;
    }
    
    @Override
    public EncryptorRuleConfiguration swap(final DuibaEncryptorRuleProperties encryptorRuleProp) {
        return new EncryptorRuleConfiguration(encryptorRuleProp.getType(), encryptorRuleProp.getProps());
    }
}
