package cn.com.duibaboot.ext.autoconfigure.initserver;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.support.AbstractApplicationContext;

/**
 * 注入PriorityOrderedBeanPostProcessorChecker的beanDefinition定义,由于是ProorityOrdered的BeanDefinitionRegistryPostProcessor，所以只能在ApplicationContextInitializer中注入
 */
public class DuibaErrorCheckerApplicationContextInitializer implements ApplicationContextInitializer<ConfigurableApplicationContext> {
    private static final Logger logger = LoggerFactory.getLogger(DuibaErrorCheckerApplicationContextInitializer.class);
    @Override
    public void initialize(ConfigurableApplicationContext applicationContext) {
        BeanDefinitionRegistry beanDefinitionRegistry = null;

        if(applicationContext instanceof BeanDefinitionRegistry){//AnnotationConfigApplicationContext
            beanDefinitionRegistry = ((BeanDefinitionRegistry)applicationContext);
        }else if (applicationContext instanceof AbstractApplicationContext) {
            beanDefinitionRegistry = (BeanDefinitionRegistry) (applicationContext)
                    .getBeanFactory();
        }

        if(beanDefinitionRegistry == null){
            logger.error("[notify me]beanDefinitionRegistry is null");
            return;
        }

        BeanDefinition bd = BeanDefinitionBuilder
                .rootBeanDefinition(PriorityOrderedBeanPostProcessorChecker.class)
                .getBeanDefinition();

        beanDefinitionRegistry.registerBeanDefinition("duibaPriorityOrderedBeanPostProcessorChecker", bd);
    }
}
