package cn.com.duibaboot.ext.autoconfigure.web.csp;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpMethod;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebFilter;
import org.springframework.web.server.WebFilterChain;
import reactor.core.publisher.Mono;

import java.nio.charset.Charset;

/**
 *  csp report log, for webflux/reactive
 */
public class CspReportReactiveFilter implements WebFilter {

    private static final Logger cspReportLogger = LoggerFactory.getLogger("duibaCspReportLog");

    @Override
    public Mono<Void> filter(ServerWebExchange exchange, WebFilterChain chain) {
        if(cspReportLogger.isInfoEnabled()) {
            String uri = exchange.getRequest().getPath().pathWithinApplication().value();
            if (uri.equals("/csp/report") && exchange.getRequest().getMethod() == HttpMethod.POST) {
                return exchange.getRequest().getBody().map(dataBuffer -> dataBuffer.asByteBuffer().array())
                        .map(bs -> new String(bs, Charset.forName("utf-8")))
                        .doOnNext(json -> cspReportLogger.info(json)).then();
            }
        }

        return chain.filter(exchange);
    }

}
