package cn.com.duibaboot.ext.autoconfigure.limiter;

import com.alibaba.fastjson.JSON;
import org.springframework.boot.actuate.endpoint.web.annotation.ControllerEndpoint;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

/**
 * @author: <a href="http://www.panaihua.com">panaihua</a>
 * @date: 2019-07-22 19:41
 * @descript: 缓存状态拦截: /monitor/servers 获取应用提供的服务
 * @version: 1.0
 */
@ControllerEndpoint(id="monitor-servers")
public class ServerApiEndpoint {

    @ResponseBody
    @RequestMapping(
            method = RequestMethod.GET,
            produces = {
                    MediaType.APPLICATION_JSON_VALUE
            }
    )
    public Object invoke() {
        return JSON.toJSONString(ServerApiAutoConfiguration.getSelfFeignClients());
    }
}
