package cn.com.duibaboot.ext.autoconfigure.monitor.cache;

import cn.com.duiba.wolf.threadpool.NamedThreadFactory;
import cn.com.duibaboot.ext.autoconfigure.javaagent.core.interceptor.enhance.InstanceMethodsAroundInterceptor;
import cn.com.duibaboot.ext.autoconfigure.javaagent.core.interceptor.enhance.MethodInterceptResult;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.RemovalListener;
import com.google.common.cache.RemovalListeners;
import lombok.extern.slf4j.Slf4j;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Date;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

/**
 * @author: <a href="http://www.panaihua.com">panaihua</a>
 * @date: 2019-07-23 16:15
 * @descript:
 * @version: 1.0
 */
@Slf4j
public class GuavaCacheBuildInterceptor implements InstanceMethodsAroundInterceptor {

    private final ExecutorService executorService = Executors.newSingleThreadExecutor(new NamedThreadFactory("duiba-guava-remove", true));

    @Override
    public void beforeMethod(Object obj, Method method, Object[] allArguments, Class<?>[] argumentsTypes, MethodInterceptResult result) throws Throwable {

        if (!"build".equals(method.getName())) {
            return;
        }

        try {

            CacheBuilder cacheBuilder = (CacheBuilder) obj;
            cacheBuilder.recordStats();
            if (this.isAlreadSetRemoval(cacheBuilder)) {
                return;
            }

            int hashcode = System.identityHashCode(cacheBuilder);
            RemovalListener<Object, Object> removalListener = RemovalListeners.asynchronous((notification -> {

                if(!CacheMonitorManager.isOpenRecord) {
                    return;
                }

                if (notification.getKey() == null) {
                    return;
                }

                CacheChangeRecord changeRecord = new CacheChangeRecord();
                changeRecord.setExpireDate(new Date());
                changeRecord.setKey(notification.getKey());
                changeRecord.setExpireType(RemovalCauseUtil.getTypeByEnumName(notification.getCause().name()));
                changeRecord.setValue(notification.getValue());
                changeRecord.setBuilderHashcode(hashcode);
                CacheMonitorManager.addRecord(changeRecord);

            }), executorService);
            cacheBuilder.removalListener(removalListener);

        } catch (Exception e) {
            log.error("cacheBuilder afterMethod excetion", e);
        }
    }

    @Override
    public Object afterMethod(Object zuperCall, Object obj, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Object ret) throws Throwable {

        CacheMonitorManager.setBuilderCache(System.identityHashCode(obj), ret);
        return ret;
    }

    @Override
    public void handleMethodException(Object obj, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Throwable t) {
        // do nothing
    }

    private boolean isAlreadSetRemoval(Object object) throws Exception {

        Field field = object.getClass().getDeclaredField("removalListener");
        field.setAccessible(true);
        boolean isRemoval = field.get(object) != null;
        field.setAccessible(false);
        return isRemoval;
    }
}
