package cn.com.duibaboot.ext.autoconfigure.rocketmq;

import cn.com.duibaboot.ext.autoconfigure.core.SpecifiedBeanPostProcessor;
import org.apache.rocketmq.client.consumer.listener.MessageListener;
import org.apache.rocketmq.client.consumer.listener.MessageListenerConcurrently;
import org.apache.rocketmq.client.consumer.listener.MessageListenerOrderly;
import org.springframework.beans.BeansException;

public class RocketmqMessageListenerPostProcessor implements SpecifiedBeanPostProcessor<MessageListener> {

    public static final int ORDER = -1;

    @Override
    public Class<MessageListener> getBeanType() {
        return MessageListener.class;
    }

    @Override
    public Object postProcessBeforeInitialization(MessageListener bean, String beanName) throws BeansException {
        return bean;
    }

    @Override
    public Object postProcessAfterInitialization(MessageListener bean, String beanName) throws BeansException {
        if(bean instanceof MessageListenerConcurrently) {
            return new MessageListenerConcurrentlyWrapper((MessageListenerConcurrently)bean, beanName);
        }else if(bean instanceof MessageListenerOrderly){
            return new MessageListenerOrderlyWrapper((MessageListenerOrderly)bean, beanName);
        }

        return bean;
    }

    @Override
    public int getOrder() {
        return ORDER;
    }
}
