package cn.com.duibaboot.ext.autoconfigure.cat;

import brave.ErrorParser;
import brave.Span;
import brave.Tracer;
import cn.com.duiba.boot.perftest.PerfTestContext;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.beans.factory.annotation.Autowired;

@Aspect
public class SleuthElasticSearchPlugin {

    @Autowired
    private Tracer tracer;
    @Autowired
    private ErrorParser errorParser;

    /**
     * 拦截ElasticsearchOperations类所有接口，记录执行耗时
     *
     * @param joinPoint
     * @return
     * @throws Throwable
     */
    @Around("execution(* org.springframework.data.elasticsearch.core.ElasticsearchOperations.*(..))")
    public Object springDataMongodbJoinPoint(ProceedingJoinPoint joinPoint) throws Throwable {
        MethodSignature signature = (MethodSignature) joinPoint.getSignature();
        String methodName = signature.getMethod().getName();

        Span curSpan = tracer.currentSpan();
        if(curSpan == null){
            return joinPoint.proceed();
        }

        Span span = tracer.nextSpan().name("elasticsearch:/"+methodName).kind(Span.Kind.CLIENT)
                .remoteServiceName("Elasticsearch")
                .start();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("ElasticsearchOperations").append(".").append(methodName);
        try(Tracer.SpanInScope scope = tracer.withSpanInScope(span)) {
            if(!span.isNoop()) {
                span.tag("elasticsearch.class_method", stringBuilder.toString());// get/...
                span.tag("lc", "ElasticsearchTemplate");//本地组件名
                span.tag("isPerfTest", Boolean.toString(PerfTestContext.isCurrentInPerfTestMode()));
                span.tag("thread", Thread.currentThread().getName());
            }
            return joinPoint.proceed();
        } catch(Exception e){
            errorParser.error(e, span);
            throw e;
        } finally {
            span.finish();
        }
    }


}
