package cn.com.duibaboot.ext.autoconfigure.datasource;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.ConfigurableApplicationContext;

/**
 * 启动早期阶段注入BeanDefinitionRegistryPostProcessor（没有使用@Bean是因为自动配置太晚，JdbcTemplateAutoConfiguration的ConditionalOnSingleCandidate不会生效）
 */
public class DuibaDataSourceRegistryContextInitializer implements ApplicationContextInitializer<ConfigurableApplicationContext> {

    private static final Logger logger = LoggerFactory.getLogger(DuibaDataSourceRegistryContextInitializer.class);

    //判断spring-jdbc jar包是否引入了，如果没有引入，则不会自动配置统一数据库连接池
    //加入这个逻辑是为了兼容config-server，config-server在获取到有duiba.datasource.*配置的项目properties时会尝试在config-server内部构造数据源，导致最终报错：[IllegalStateException: 检测到你的项目中需要使用dataSource，目前强制使用dbcp2，请引入dbcp2 的jar依赖.]
    private static volatile boolean isSpringJdbcJarImported;

    static{
        boolean isSpringJdbcJarImportedTemp = false;
        try {
            Class.forName("org.springframework.jdbc.core.JdbcTemplate");
            isSpringJdbcJarImportedTemp = true;
        } catch (ClassNotFoundException e) {
            // Ignore
            logger.debug("没有检测到spring-jdbc依赖，不会进行自动配置统一数据库连接池");
        }

        DuibaDataSourceRegistryContextInitializer.isSpringJdbcJarImported = isSpringJdbcJarImportedTemp;
    }

    @Override
    public void initialize(ConfigurableApplicationContext applicationContext) {
        if(!isSpringJdbcJarImported){
            //判断spring-jdbc jar包是否引入了，如果没有引入，则不会自动配置统一数据库连接池
            return;
        }
        DataSourceBeanDefinitionRegistryPostProcessor processor = new DataSourceBeanDefinitionRegistryPostProcessor();
        processor.setEnvironment(applicationContext.getEnvironment());
        applicationContext.addBeanFactoryPostProcessor(processor);
    }
}
