package cn.com.duibaboot.ext.autoconfigure.perftest;

import com.zaxxer.hikari.HikariDataSource;
import lombok.extern.slf4j.Slf4j;
import org.springframework.core.env.Environment;

/**
 * 自动根据当前是不是压测请求决定访问原始数据库或者影子库
 * Created by wenqi.huang on 2016/11/24.
 */
@Slf4j
public class PerfTestRoutingDataSourceForHikari extends PerfTestRoutingDataSource<HikariDataSource> {

    public PerfTestRoutingDataSourceForHikari(HikariDataSource originalDataSource, Environment environment, PerfTestFootMarker perfTestFootMarker) {
        super(originalDataSource, environment, perfTestFootMarker);
    }

    @Override
    protected String getJdbcUrl(HikariDataSource originalDataSource){
        return originalDataSource.getJdbcUrl();
    }

    @Override
    protected HikariDataSource copyDataSource(String testUrl, HikariDataSource originalDataSource){
        HikariDataSource ds = new HikariDataSource();
        ds.setDriverClassName(originalDataSource.getDriverClassName());
        ds.setJdbcUrl(testUrl);
        ds.setUsername(originalDataSource.getUsername());
        ds.setPassword(originalDataSource.getPassword());

        ds.setLeakDetectionThreshold(originalDataSource.getLeakDetectionThreshold());
        ds.setMaximumPoolSize(originalDataSource.getMaximumPoolSize());
        ds.setMinimumIdle(0);//压测连接池最小空闲设为0，这样可以在没有压测行为的时候尽快释放压测连接；
        ds.setIdleTimeout(30000);//清理所有空闲了30秒的压测连接，只保留minIdle个连接

        ds.setValidationTimeout(originalDataSource.getValidationTimeout());
        ds.setConnectionTimeout(originalDataSource.getConnectionTimeout());

        ds.setPoolName(originalDataSource.getPoolName() + "_shade");
        ds.setConnectionInitSql(originalDataSource.getConnectionInitSql());

        return ds;
    }

}
