package cn.com.duibaboot.ext.autoconfigure.perftest;

import javax.annotation.Resource;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.data.redis.connection.RedisConnection;
import org.springframework.data.redis.connection.jedis.JedisClusterConnection;
import org.springframework.data.redis.connection.jedis.JedisConnection;

/**
 * Created by guoyanfei .
 * 2018/11/2 .
 */
@Aspect
public class PerfTestSpringDataRedisPlugin {

    @Resource
    private PerfTestFootMarker perfTestFootMarker;

    @Around("execution(* org.springframework.data.redis.connection.jedis.JedisConnectionFactory.getConnection(..))")
    public Object springDataRedisJoinPoint(ProceedingJoinPoint joinPoint) throws Throwable{
        MethodSignature signature = (MethodSignature) joinPoint.getSignature();
        String methodName = signature.getMethod().getName();
        if ("getConnection".equals(methodName)) {
            Object connectionObj = joinPoint.proceed();
            RedisConnection connection;
            if (connectionObj instanceof JedisClusterConnection) {
                connection = (JedisClusterConnection) connectionObj;
            } else {
                connection = (JedisConnection) connectionObj;
            }
            perfTestFootMarker.markRedis(this.getHost(connection));
            return connection;
        }
        return joinPoint.proceed();
    }

    private String getHost(RedisConnection connection) {
        if (connection == null) {
            return null;
        }
        return connection.getClientName();
//        if (connection.getNativeConnection().getClient() == null) {
//            return null;
//        }
//        return connection.getNativeConnection().getClient().getHost();
    }
}
