package cn.com.duibaboot.ext.autoconfigure.cloud.netflix.hystrix;

import cn.com.duibaboot.ext.autoconfigure.core.SpecifiedBeanPostProcessor;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.beans.BeansException;
import org.springframework.boot.actuate.endpoint.web.EndpointServlet;
import org.springframework.cloud.netflix.hystrix.HystrixStreamEndpoint;

import java.lang.reflect.Field;
import java.util.Map;

/**
 * 这个类用于修复/hystrix.stream的bug：https://github.com/Netflix/Hystrix/issues/1756
 * <br/>
 * 对HttpServletResponse.PrintWriter的方法进行aop,从而进行必要的同步保护,以修复HystrixSampleSseServlet多线程往writer中写导致tomcat出错的问题。
 * <br/>
 * 等官方修复这个bug后可以去掉这个类。
 */
public class HystrixStreamEndpointPostProcessor implements SpecifiedBeanPostProcessor<HystrixStreamEndpoint> {
    @Override
    public Class<HystrixStreamEndpoint> getBeanType() {
        return HystrixStreamEndpoint.class;
    }

    @Override
    public Object postProcessBeforeInitialization(HystrixStreamEndpoint bean, String beanName) throws BeansException {
        return bean;
    }

    @Override
    public Object postProcessAfterInitialization(HystrixStreamEndpoint bean, String beanName) throws BeansException {
        ProxyFactory factory = new ProxyFactory();
        factory.setTarget(bean);
        factory.addAdvice(new HystrixStreamEndpointMethodInterceptor());
        return factory.getProxy();
    }

    @Override
    public int getOrder() {
        return 0;
    }

    static class HystrixStreamEndpointMethodInterceptor implements MethodInterceptor{

        @Override
        public Object invoke(MethodInvocation invocation) throws Throwable {
            String methodName = invocation.getMethod().getName();
            if(methodName.equals("get")){
                HystrixStreamEndpoint e = (HystrixStreamEndpoint)invocation.getThis();
                Field field = HystrixStreamEndpoint.class.getDeclaredField("initParameters");
                field.setAccessible(true);
                Map<String, String> initParameters = (Map<String, String>)field.get(e);

                return new EndpointServlet(ThreadSafeHystrixMetricsStreamServlet.class)
                        .withInitParameters(initParameters);
            }

            return invocation.proceed();
        }
    }
}
