package cn.com.duibaboot.ext.autoconfigure.grouping;

import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.http.HttpCookie;
import org.springframework.http.server.reactive.ServerHttpRequest;

import static cn.com.duibaboot.ext.autoconfigure.grouping.ServiceGroupUtils.DUIBA_SERVICE_GROUP_KEY;

/**
 * 服务分组标识获取的工具类,reactive版
 * 目前用于支持需求：http://cf.dui88.com/pages/viewpage.action?pageId=11134823
 * Created by guoyanfei .
 * 2018/11/7 .
 */
@Slf4j
public final class ReactiveServiceGroupUtils {

    private ReactiveServiceGroupUtils() {
    }

    /**
     * 从request中获取服务分组标识，服务分组标识可以再以下任一地方
     * <br/>
     * cookie 中有 _duibaServiceGroupKey
     * <br/>
     * header 中有 _duibaServiceGroupKey
     * @param request
     * @return 服务分组标识，可能为nul
     */
    public static String getDuibaServiceGroupKey(ServerHttpRequest request) {
        String groupKey = null;
        HttpCookie cookie = request.getCookies().getFirst(DUIBA_SERVICE_GROUP_KEY);
        if (cookie != null) {
            groupKey = cookie.getValue();
        }
        if (StringUtils.isBlank(groupKey)) {
            groupKey = request.getHeaders().getFirst(DUIBA_SERVICE_GROUP_KEY);
        }
        return groupKey;
    }
}
