package cn.com.duibaboot.ext.autoconfigure.cat;

import org.springframework.boot.context.properties.ConfigurationProperties;

/**
 * cat相关配置项
 * Created by gyf .
 * 2020/12/15 .
 */
@ConfigurationProperties(prefix = "duiba.cat")
public class CatProperties {

    /**
     * 该属性可以设置应用监控的transaction中url是否是折叠的,默认折叠
     * true表示折叠,案例：/test/request/test2/{id}/{id2}
     * false表示展开,案例：/test/request/test2/xxaaa/xxx, /test/request/test2/xxx1/xasdas2...
     *
     * 注意，目前只支持字符串的展开，不支持纯数字的展开，如果此设置的是 false，但是 id 和 id2 是纯数字，那么cat展示的会是 /test/request/test2/{num}/{num}
     */
    private boolean transactionUrlFolded = true;

    public boolean isTransactionUrlFolded() {
        return transactionUrlFolded;
    }

    public void setTransactionUrlFolded(boolean transactionUrlFolded) {
        this.transactionUrlFolded = transactionUrlFolded;
    }
}
