package cn.com.duibaboot.ext.autoconfigure.perftest;

import cn.com.duiba.wolf.redis.RedisClient;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import redis.clients.jedis.Client;
import redis.clients.jedis.Jedis;

import javax.annotation.Resource;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

/**
 * 在执行 RedisClient 的操作的时候，打上压测流量足迹（如果不是压测模式，不会打）
 * Created by guoyanfei .
 * 2018/11/2 .
 */
@Slf4j
@Aspect
public class PerfTestRedisCachePlugin {

    @Resource
    private PerfTestFootMarker perfTestFootMarker;

    private Map<RedisClient, String> jedisHostMap = new ConcurrentHashMap<>();

    @Around("execution(* cn.com.duiba.wolf.redis.RedisClient.*(..))")
    public Object redisJoinPoint(ProceedingJoinPoint joinPoint) throws Throwable {
        RedisClient redisClient = (RedisClient) joinPoint.getTarget();
        String host = this.getHosts(redisClient);
        if (StringUtils.isNotBlank(host)) {
            perfTestFootMarker.markRedis(host);
        }
        return joinPoint.proceed();
    }

    private String getHosts(RedisClient redisClient) {
        String jedisHost = jedisHostMap.get(redisClient);
        if (StringUtils.isNotBlank(jedisHost)) {
            return jedisHost;
        }
        String newJedisHost = this.getNewJedisHost(redisClient);
        if (StringUtils.isBlank(newJedisHost)) {
            return null;
        }
        String jedisHostTemp = jedisHostMap.putIfAbsent(redisClient, newJedisHost);
        if (jedisHostTemp != null) {
            newJedisHost = jedisHostTemp;
        }
        return newJedisHost;
    }

    private String getNewJedisHost(RedisClient redisClient) {
        Jedis jedis = null;
        try {
            Class<?> redisClientClass = redisClient.getClass();
            Method method = redisClientClass.getDeclaredMethod("getResource");
            method.setAccessible(true);
            jedis = (Jedis) method.invoke(redisClient);
            if (jedis == null) {
                return null;
            }
            Client client = jedis.getClient();
            return client != null ? client.getHost() : null;
        } catch (Exception e) {
            log.error("getNewJedisHost error", e);
        } finally {
            if (jedis != null) {
                jedis.close();
            }
        }
        return null;
    }

}
