package cn.com.duibaboot.ext.autoconfigure.datasource.encrypt;

import cn.com.duiba.boot.utils.PropertyUtil;
import cn.com.duibaboot.ext.autoconfigure.datasource.encrypt.config.DuibaDBEncryptProperties;
import org.springframework.boot.autoconfigure.condition.ConditionOutcome;
import org.springframework.boot.autoconfigure.condition.SpringBootCondition;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.core.type.AnnotatedTypeMetadata;

/**
 * Encrypt condition.
 * 判断环境中是否存在 duiba.db.encrypt 开头的配置项，来确认数据库加密的自动配置是否执行
 */
public final class DuibaDBEncryptCondition extends SpringBootCondition {

    @Override
    public ConditionOutcome getMatchOutcome(final ConditionContext conditionContext, final AnnotatedTypeMetadata annotatedTypeMetadata) {
        boolean isEncrypt = PropertyUtil.containPropertyPrefix(conditionContext.getEnvironment(), DuibaDBEncryptProperties.DUIBA_DB_ENCRYPT_PREFIX);
        return isEncrypt ? ConditionOutcome.match() : ConditionOutcome.noMatch("Can't find encrypt rule configuration in environment.");
    }
}
