package cn.com.duibaboot.ext.autoconfigure.etcd;

import cn.com.duibaboot.ext.autoconfigure.etcd.properties.EtcdProperties;
import io.etcd.jetcd.Client;
import io.etcd.jetcd.maintenance.StatusResponse;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.boot.actuate.endpoint.annotation.Endpoint;
import org.springframework.boot.actuate.endpoint.annotation.ReadOperation;

import java.net.URI;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;

@Endpoint(id="etcd")
public class EtcdEndpoint {

    private final Client etcdClient;

    private final EtcdProperties etcdProperties;

    public EtcdEndpoint(Client etcdClient, EtcdProperties etcdProperties) {
        this.etcdClient = etcdClient;
        this.etcdProperties = etcdProperties;
    }

    @ReadOperation
    public EtcdStatus getEtcdStatus() {
        List<EtcdMemberStatus> memberStatuses = etcdProperties.getUris().stream().map(endpoint -> {
            try {
                StatusResponse response = etcdClient.getMaintenanceClient().statusMember(URI.create(endpoint)).get();
                return new EtcdMemberStatus(endpoint, response.getVersion());
            } catch (InterruptedException | ExecutionException e) {
                throw new IllegalStateException(e);
            }
        }).collect(Collectors.toList());
        return new EtcdStatus(memberStatuses);
    }

    @Data
    @NoArgsConstructor
    @AllArgsConstructor
    static class EtcdStatus {

        private List<EtcdMemberStatus> members;
    }

    @Data
    @NoArgsConstructor
    @AllArgsConstructor
    static class EtcdMemberStatus {

        private String endpoint;

        private String version;
    }
}
