package cn.com.duibaboot.ext.autoconfigure.flowreplay.record.endpoint;

import cn.com.duibaboot.ext.autoconfigure.flowreplay.FlowReplayException;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.JsonResult;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.record.RecordContext;
import cn.com.duibaboot.ext.autoconfigure.flowreplay.record.RecordContextHolder;
import com.alibaba.fastjson.JSONObject;

import org.springframework.boot.actuate.endpoint.annotation.Endpoint;
import org.springframework.boot.actuate.endpoint.annotation.ReadOperation;
import org.springframework.web.bind.annotation.RequestParam;

/**
 * 流量录制结果查询
 */
@Endpoint(id="flow-record-result")
public class RecordResultMvcEndpoint {

    @ReadOperation
    public String invoke(@RequestParam Long usecaseSetId) {
        JsonResult<JSONObject> result;
        try {
            RecordContext context = RecordContextHolder.getRecordContext();
            if (context == null) {
                throw new FlowReplayException("录制未开始");
            }
            if (!usecaseSetId.equals(context.getUsecaseSetId())) {
                throw new FlowReplayException("非法的用例集ID");
            }
            JSONObject recordResult = new JSONObject();
            if (!RecordContextHolder.isRecording() && context.getRecordResult() != null) {
                recordResult.put("isEnded", true);
                recordResult.put("result", context.getRecordResult());
            } else {
                recordResult.put("isEnded", false);
                recordResult.put("result", null);
            }
            result = JsonResult.successResult(recordResult);
        } catch (Exception e) {
            result = JsonResult.failedResult(e.getMessage());
        }
        return result.toJSONString();
    }

}
