package cn.com.duibaboot.ext.autoconfigure.monitor.jvm;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.client.RestTemplate;

import java.util.HashMap;
import java.util.Map;

/**
 * Created by guoyanfei .
 * 2021/6/10 .
 */
public class JvmAlertComponent {

    private static final Logger LOGGER = LoggerFactory.getLogger(JvmAlertComponent.class);

    @Value("${spring.application.name}")
    private String currentAppName;

    private final RestTemplate loadBalancedRestTemplate;

    public JvmAlertComponent(RestTemplate loadBalancedRestTemplate) {
        this.loadBalancedRestTemplate = loadBalancedRestTemplate;
    }

    public void doAlert(int ruleMinutes, String ruleValue, String currentValue, String msg) {
        Map<String, Object> paramMap = new HashMap<>();
        paramMap.put("appName", currentAppName);
        paramMap.put("ruleMinutes", ruleMinutes);
        paramMap.put("ruleValue", ruleValue);
        paramMap.put("currentValue", currentValue);
        paramMap.put("msg", msg);
        try {
            LOGGER.warn("jvm告警, {}, {}分钟 {}, 阈值:{}", msg, ruleMinutes, currentValue, ruleValue);
            loadBalancedRestTemplate.postForObject("http://prism/prism/jvmAlert/gcAlert", paramMap, String.class);
        } catch (Exception e) {
            LOGGER.error("jvm告警异常, {}", e.getMessage());
        }
    }
}
