package cn.com.duibaboot.ext.autoconfigure.web;

import cn.com.duiba.boot.utils.RequestUtils;
import cn.com.duiba.wolf.utils.DateUtils;
import cn.com.duibaboot.ext.autoconfigure.cloud.netflix.eureka.CommonDiscoveryMetadataRegister;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;

import javax.servlet.*;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;

/**
 * Ready过滤器，提供 /isReady 接口
 * Created by guoyanfei .
 * 2021/6/15 .
 */
public class ServiceReadyFilter implements Filter {

    private static final Logger LOGGER = LoggerFactory.getLogger(ServiceReadyFilter.class);

    private final Integer duibaWarmUpTimeMillis;

    public ServiceReadyFilter(Integer duibaWarmUpTimeMillis) {
        this.duibaWarmUpTimeMillis = duibaWarmUpTimeMillis;
    }

    @Override
    public void init(FilterConfig filterConfig) throws ServletException {
        //do nothing
    }

    @Override
    public void destroy() {
        //do nothing
    }

    @Override
    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest) servletRequest;
        HttpServletResponse response = (HttpServletResponse) servletResponse;
        String requestPath = RequestUtils.getRequestPath(request);
        if (requestPath.equals("/isReady")) {//检查服务器就绪状态，OK表示正常，INVALID表示服务不可用
            if (!ServerReadyStatusHolder.isReady()) {
                long serverStartUpTime = CommonDiscoveryMetadataRegister.getServerStartUpTimeOuternal();
                long currentTime = System.currentTimeMillis();
                if (serverStartUpTime > 0 && (serverStartUpTime + duibaWarmUpTimeMillis < currentTime)) {
                    ServerReadyStatusHolder.makeReady();
                    LOGGER.warn("预热完成, 应用就绪, serverStartUpTime={}, duibaWarmUpTimeMillis={}, currentTime={}", DateUtils.getSecondStr(serverStartUpTime), duibaWarmUpTimeMillis, DateUtils.getSecondStr(currentTime));
                }

                response.setStatus(ServerReadyStatusHolder.isReady() ? HttpStatus.OK.value() : HttpStatus.SERVICE_UNAVAILABLE.value());
            }
            response.getWriter().write(ServerReadyStatusHolder.isReady() ? "OK" : "INVALID");
        } else {
            filterChain.doFilter(servletRequest, servletResponse);
        }
    }
}
