package cn.com.duibaboot.ext.autoconfigure.data.hbase;

import cn.com.duiba.boot.utils.SpringEnvironmentUtils;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.core.env.Environment;
import org.springframework.core.type.AnnotationMetadata;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;

/**
 * 注入额外的 Connection
 */
//也可以用BeanDefinitionRegistryPostProcessor来注入BeanDefinition
public class ExtraHbaseImportBeanDefinitionRegistrar implements ImportBeanDefinitionRegistrar, EnvironmentAware {

    private List<String> extraHbaseConnectionKeys = new ArrayList<>();

    @Override
    public void registerBeanDefinitions(AnnotationMetadata importingClassMetadata, BeanDefinitionRegistry registry) {
        for (String extraHbaseConnectionKey : extraHbaseConnectionKeys) {
            BeanDefinition extraHbaseConnectionDefinition = BeanDefinitionBuilder
                    .genericBeanDefinition(HbaseConnectionFactoryBean.class)
                    .addConstructorArgValue(extraHbaseConnectionKey)
                    .getBeanDefinition();

            registry.registerBeanDefinition(extraHbaseConnectionKey, extraHbaseConnectionDefinition);
        }
    }

    @Override
    public void setEnvironment(Environment environment) {
        String hbaseExtraIdPrefix = "duiba.hbase.extra.";
        String hbaseExtraIdPostfix = ".zk-quorum";
        String hbaseExtraIdPostfixOther = ".zkQuorum";
        LinkedHashMap<String, Object> props = SpringEnvironmentUtils.getFlatEnvironments(environment);
        props.entrySet().stream()
                .filter(e -> e.getKey().startsWith(hbaseExtraIdPrefix) && (e.getKey().endsWith(hbaseExtraIdPostfix) || e.getKey().endsWith(hbaseExtraIdPostfixOther)))
                .map(e -> e.getKey().split("\\.")[3])
                .forEach(s -> extraHbaseConnectionKeys.add(s));
    }

    public static class HbaseConnectionFactoryBean implements FactoryBean<Connection> {

        @Resource
        private HbaseProperties hbaseProperties;

        private String extraKey;

        public HbaseConnectionFactoryBean(String extraKey) {
            this.extraKey = extraKey;
        }

        @Override
        public Connection getObject() throws Exception {
            org.apache.hadoop.conf.Configuration configuration = hbaseProperties.getExtra().get(extraKey).getConfiguration();
            Connection connection = ConnectionFactory.createConnection(configuration);
            return connection;
        }

        @Override
        public Class<Connection> getObjectType() {
            return Connection.class;
        }

        @Override
        public boolean isSingleton() {
            return true;
        }

    }
}
