package cn.com.duibaboot.ext.autoconfigure.httpclient;

import cn.com.duibaboot.ext.autoconfigure.cloud.netflix.feign.CustomRequestInterceptor;
import cn.com.duibaboot.ext.autoconfigure.grouping.ServiceGroupContext;
import cn.com.duibaboot.ext.autoconfigure.grouping.ServiceGroupUtils;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.http.Header;
import org.apache.http.HttpRequest;

import java.util.HashMap;
import java.util.Map;

/**
 * 一个HttpClient方法拦截器的实现，用于实现添加header
 * <p>
 * 1.多场景k/v
 * 2.压测k/v
 */
class HttpClientHeaderMethodInterceptor implements HttpClientMethodInterceptor {

    @Override
    public Object invoke(MethodInvocation invocation) throws Throwable {
        if (!"execute".equals(invocation.getMethod().getName())) {
            return invocation.proceed();
        }

        HttpRequest request = null;
        Object[] args = invocation.getArguments();
        for (Object arg : args) {
            if (arg instanceof HttpRequest) {
                request = (HttpRequest) arg;
                break;
            }
        }
        if (request == null) {
            return invocation.proceed();
        }

        Header[] headers = request.getHeaders(CustomRequestInterceptor.X_RPC);
        if (headers != null && headers.length > 0 && "true".equals(headers[0].getValue())) {
            // 已经标记为rpc请求的，不再处理header
            return invocation.proceed();
        }

        putHeader(request);

        return invocation.proceed();
    }

    private void putHeader(HttpRequest request) {
        Map<String, Object> extHeaderMap = new HashMap<>();

        addServiceGroupHeader(extHeaderMap);

        if (extHeaderMap.isEmpty()) {
            return;
        }

        extHeaderMap.forEach((k, v) -> {
            if (v != null) {
                request.addHeader(k, v.toString());
            }
        });
    }

    /**
     * 添加服务分组key
     *
     * @param extHeaderMap
     */
    private void addServiceGroupHeader(Map<String, Object> extHeaderMap) {
        String currentGroupKey = ServiceGroupContext.getCurrentGroupKey();
        if (currentGroupKey == null) {
            return;
        }

        // 多场景 header
        extHeaderMap.put(ServiceGroupUtils.DUIBA_SERVICE_GROUP_KEY, ServiceGroupContext.getCurrentGroupKey());
    }

    @Override
    public int getOrder() {
        // 写入k/v晚于cat监控，确保cat监控的准确性
        return 0;
    }

}
