package cn.com.duibaboot.ext.autoconfigure.perftest.core;

import cn.com.duiba.boot.perftest.PerfTestUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.boot.autoconfigure.condition.ConditionOutcome;
import org.springframework.boot.autoconfigure.condition.SpringBootCondition;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.core.type.AnnotatedTypeMetadata;

/**
 * 判断当前机器是否是压测专用机器
 * Created by guoyanfei .
 * 2022/3/1 .
 */
public class PerfTestEnvCondition extends SpringBootCondition {

    @Override
    public ConditionOutcome getMatchOutcome(ConditionContext context, AnnotatedTypeMetadata metadata) {
        return PerfTestUtils.isPerfTestEnv() ? ConditionOutcome.match("匹配到当前是压测环境") : ConditionOutcome.noMatch(StringUtils.EMPTY);
    }
}
