package cn.com.duibaboot.ext.autoconfigure.perftest.core;

import org.apache.commons.collections4.CollectionUtils;

import java.util.HashSet;
import java.util.Set;

/**
 * 不支持压测的应用列表
 * Created by guoyanfei .
 * 2022/3/8 .
 */
public final class UnsupportedAppsHolder {

    private UnsupportedAppsHolder() {
    }

    private static volatile Set<String> unsupportedApps;

    public static void _setUnsupportedApps(PerfTestProperties perfTestProperties) {
        Set<String> temp = new HashSet<>();
        if (CollectionUtils.isNotEmpty(perfTestProperties.getCustomUnsupportedApps())) {
            temp.addAll(perfTestProperties.getCustomUnsupportedApps());
        }
        if (CollectionUtils.isNotEmpty(perfTestProperties.getGlobalUnsupportedApps())) {
            temp.addAll(perfTestProperties.getGlobalUnsupportedApps());
        }
        unsupportedApps = temp;
    }

    public static Set<String> getUnsupportedApps() {
        return unsupportedApps;
    }

    public static boolean isUnsupportedApp(String targetApp) {
        return unsupportedApps.contains(targetApp);
    }
}
