package cn.com.duibaboot.ext.autoconfigure.perftest.httpclient;

import cn.com.duibaboot.ext.autoconfigure.core.SpecifiedBeanPostProcessor;
import cn.com.duiba.boot.perftest.PerfTestUtils;
import org.apache.http.impl.client.CloseableHttpClient;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.beans.BeansException;

public class PerfTestHttpClientBeanPostProcessor implements SpecifiedBeanPostProcessor<CloseableHttpClient> {

    @Override
    public Class<CloseableHttpClient> getBeanType() {
        return CloseableHttpClient.class;
    }

    @Override
    public Object postProcessBeforeInitialization(CloseableHttpClient bean, String beanName) throws BeansException {
        return bean;
    }

    @Override
    public Object postProcessAfterInitialization(CloseableHttpClient bean, String beanName) throws BeansException {
        // 如果当前不是压测环境，直接返回bean
        if (!PerfTestUtils.isPerfTestEnv()) {
            return bean;
        }
        ProxyFactory proxyFactory = new ProxyFactory();
        proxyFactory.setTarget(bean);
        proxyFactory.addAdvice(new PerfTestHttpClientMethodInterceptor());
        return proxyFactory.getProxy();
    }

    @Override
    public int getOrder() {
        return 0;
    }

}
