package cn.com.duibaboot.ext.autoconfigure.perftest.jest;

import cn.com.duibaboot.ext.autoconfigure.javaagent.core.interceptor.enhance.InstanceMethodsAroundInterceptor;
import cn.com.duibaboot.ext.autoconfigure.javaagent.core.interceptor.enhance.MethodInterceptResult;
import cn.com.duiba.boot.perftest.PerfTestConstant;
import cn.com.duiba.boot.perftest.PerfTestUtils;

import java.lang.reflect.Method;

/**
 * Jest支持压测，修改index，加上前缀perf__
 */
public class JestBulkMethodInterceptor implements InstanceMethodsAroundInterceptor {

    @Override
    public void beforeMethod(Object objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, MethodInterceptResult result) throws Throwable {
        if (PerfTestUtils.isPerfTestEnv()) {
            String methodName = method.getName();
            if (methodName.equals("defaultIndex")) {
                String originalIndex = (String) allArguments[0];
                allArguments[0] = PerfTestConstant.TEST_SCHEME_PREFIX + originalIndex;
            }
        }
    }

    @Override
    public Object afterMethod(Object zuperCall, Object objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Object ret) throws Throwable {
        return ret;
    }

    @Override
    public void handleMethodException(Object objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Throwable t) {
        //do nothing
    }
}
