package cn.com.duibaboot.ext.autoconfigure.perftest.log;

import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.spi.LoggingEvent;
import ch.qos.logback.core.filter.Filter;
import ch.qos.logback.core.spi.FilterReply;
import cn.com.duiba.boot.perftest.PerfTestUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.util.ReflectionUtils;

import java.lang.reflect.Field;

/**
 * 在线程名后面附加Perf标记，表示当前线程在压测
 */
public class PerfTestLogNameFilter extends Filter<ILoggingEvent> {

    private static final Field threadNameField;

    static {
        threadNameField = ReflectionUtils.findField(LoggingEvent.class, "threadName");
        threadNameField.setAccessible(true);
    }

    @Override
    public FilterReply decide(ILoggingEvent event) {
        if (!PerfTestUtils.isPerfTestEnv()) {
            return FilterReply.NEUTRAL;
        }
        if (event instanceof LoggingEvent) {
            Object threadName = ReflectionUtils.getField(threadNameField, event);
            try {
                if (threadName == null) {
                    ((LoggingEvent) event).setThreadName(Thread.currentThread().getName() + ":Perf_" + StringUtils.trimToEmpty(PerfTestUtils.getSceneId()));
                } else {
                    ((LoggingEvent) event).setThreadName(threadName + ":Perf_" + StringUtils.trimToEmpty(PerfTestUtils.getSceneId()));
                }
            } catch (IllegalStateException e) {
                // Ignore
            }
        }
        return FilterReply.NEUTRAL;
    }

}
