/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.spring.boot.starter.dsp.model.model;

import cn.com.duiba.nezha.alg.model.tf.LocalTFModel;
import cn.com.duiba.spring.boot.starter.dsp.model.enums.AlgoTFModelStatusEnum;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AlgoTFModel {
    private static final Logger log = LoggerFactory.getLogger(AlgoTFModel.class);
    private static final Long CLOSE_TF_MODEL_TIME = 120000L;
    private LocalTFModel localTFModel;
    private Long lastAccessTime;
    private Long loadTime;
    private int status;
    private String name;

    public AlgoTFModel(int status, String name) {
        this.status = status;
        this.name = name;
    }

    public AlgoTFModel(LocalTFModel localTFModel, int status, String name) {
        this.localTFModel = localTFModel;
        this.status = status;
        this.loadTime = System.currentTimeMillis();
        this.name = name;
    }

    public LocalTFModel getLocalTFModel() {
        this.lastAccessTime = System.currentTimeMillis();
        return this.localTFModel;
    }

    public boolean isRunning() {
        return this.status == AlgoTFModelStatusEnum.RUNNING.getCode();
    }

    public boolean isAllowClose() {
        return this.lastAccessTime != null && System.currentTimeMillis() - this.lastAccessTime > CLOSE_TF_MODEL_TIME;
    }

    public void doCloseTFModel() {
        try {
            this.localTFModel.close();
            log.info("\u5173\u95edtf\u6a21\u578b, name:{}", (Object)this.name);
        }
        catch (Exception e) {
            log.warn("AlgoTFModel doClose error", (Throwable)e);
            return;
        }
        this.localTFModel = null;
        this.status = AlgoTFModelStatusEnum.STOP.getCode();
        this.lastAccessTime = null;
        this.loadTime = null;
    }

    public boolean isLatestVersion(LocalTFModel localTFModel, String tfKey) {
        try {
            Long lastVersion = localTFModel.getLastVersion(tfKey);
            return !Objects.equals(String.valueOf(lastVersion), this.localTFModel.getVersion());
        }
        catch (Exception e) {
            log.warn("AlgoTFModel getLastVersion error", (Throwable)e);
            return false;
        }
    }

    public void loadTFModel(LocalTFModel localTFModel, String tfKey) {
        try {
            localTFModel.loadModel(tfKey);
            log.info("\u52a0\u8f7dtf\u6a21\u578b, name:{}", (Object)this.name);
        }
        catch (Exception e) {
            log.warn("AlgoTFModel loadModel error", (Throwable)e);
            return;
        }
        this.status = AlgoTFModelStatusEnum.RUNNING.getCode();
        this.loadTime = System.currentTimeMillis();
        this.localTFModel = localTFModel;
    }

    public Long getLastAccessTime() {
        return this.lastAccessTime;
    }

    public Long getLoadTime() {
        return this.loadTime;
    }

    public int getStatus() {
        return this.status;
    }

    public String getName() {
        return this.name;
    }

    public void setLocalTFModel(LocalTFModel localTFModel) {
        this.localTFModel = localTFModel;
    }

    public void setLastAccessTime(Long lastAccessTime) {
        this.lastAccessTime = lastAccessTime;
    }

    public void setLoadTime(Long loadTime) {
        this.loadTime = loadTime;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AlgoTFModel)) {
            return false;
        }
        AlgoTFModel other = (AlgoTFModel)o;
        if (!other.canEqual(this)) {
            return false;
        }
        LocalTFModel this$localTFModel = this.getLocalTFModel();
        LocalTFModel other$localTFModel = other.getLocalTFModel();
        if (this$localTFModel == null ? other$localTFModel != null : !this$localTFModel.equals(other$localTFModel)) {
            return false;
        }
        Long this$lastAccessTime = this.getLastAccessTime();
        Long other$lastAccessTime = other.getLastAccessTime();
        if (this$lastAccessTime == null ? other$lastAccessTime != null : !((Object)this$lastAccessTime).equals(other$lastAccessTime)) {
            return false;
        }
        Long this$loadTime = this.getLoadTime();
        Long other$loadTime = other.getLoadTime();
        if (this$loadTime == null ? other$loadTime != null : !((Object)this$loadTime).equals(other$loadTime)) {
            return false;
        }
        if (this.getStatus() != other.getStatus()) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        return !(this$name == null ? other$name != null : !this$name.equals(other$name));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AlgoTFModel;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        LocalTFModel $localTFModel = this.getLocalTFModel();
        result = result * 59 + ($localTFModel == null ? 43 : $localTFModel.hashCode());
        Long $lastAccessTime = this.getLastAccessTime();
        result = result * 59 + ($lastAccessTime == null ? 43 : ((Object)$lastAccessTime).hashCode());
        Long $loadTime = this.getLoadTime();
        result = result * 59 + ($loadTime == null ? 43 : ((Object)$loadTime).hashCode());
        result = result * 59 + this.getStatus();
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        return result;
    }

    public String toString() {
        return "AlgoTFModel(localTFModel=" + this.getLocalTFModel() + ", lastAccessTime=" + this.getLastAccessTime() + ", loadTime=" + this.getLoadTime() + ", status=" + this.getStatus() + ", name=" + this.getName() + ")";
    }
}

