/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.spring.boot.starter.dsp.rateLimiter;

import cn.com.duiba.spring.boot.starter.dsp.rateLimiter.RateLimit;
import cn.com.duiba.spring.boot.starter.dsp.rateLimiter.RateLimitProperties;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.data.redis.core.script.DefaultRedisScript;
import org.springframework.stereotype.Component;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Aspect
@Component
public class LimitAspect {
    private static final Logger logger = LoggerFactory.getLogger(LimitAspect.class);
    @Resource(name="redis03StringRedisTemplate")
    private StringRedisTemplate stringRedisTemplate;
    @Autowired
    private DefaultRedisScript<Long> redisLuaScript;
    @Autowired
    private RateLimitProperties rateLimitProperties;

    @Pointcut(value="@annotation(cn.com.duiba.spring.boot.starter.dsp.rateLimiter.RateLimit)")
    public void rateLimitPointcut() {
    }

    @Around(value="rateLimitPointcut()")
    public Object interceptor(ProceedingJoinPoint joinPoint) throws Throwable {
        if (!this.rateLimitProperties.isAdxRateLimitSwitch()) {
            return joinPoint.proceed();
        }
        MethodSignature signature = (MethodSignature)joinPoint.getSignature();
        Method method = signature.getMethod();
        Class<?> targetClass = method.getDeclaringClass();
        RateLimit rateLimit = method.getAnnotation(RateLimit.class);
        if (rateLimit == null) {
            return joinPoint.proceed();
        }
        HttpServletRequest request = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
        String ipAddress = LimitAspect.getIpAddress(request);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(ipAddress).append("-").append(targetClass.getName()).append("-").append(method.getName()).append("-").append(rateLimit.key());
        logger.info("\u9650\u6d41\u5566, redis key{}", (Object)stringBuffer.toString());
        List<String> keys = Collections.singletonList(stringBuffer.toString());
        Long number = (Long)this.stringRedisTemplate.execute(this.redisLuaScript, keys, new Object[]{String.valueOf(rateLimit.count()), String.valueOf(rateLimit.time())});
        if (number != null && number != 0L && number <= (long)rateLimit.count()) {
            logger.info("\u9650\u6d41\u65f6\u95f4\u6bb5\u5185\u8bbf\u95ee\u7b2c\uff1a{} \u6b21", (Object)number);
            return joinPoint.proceed();
        }
        throw new RuntimeException("\u5df2\u7ecf\u5230\u8bbe\u7f6e\u9650\u6d41\u6b21\u6570");
    }

    private static String getIpAddress(HttpServletRequest request) {
        String ipAddress;
        try {
            ipAddress = request.getHeader("x-forwarded-for");
            if (ipAddress == null || ipAddress.length() == 0 || "unknown".equalsIgnoreCase(ipAddress)) {
                ipAddress = request.getHeader("Proxy-Client-IP");
            }
            if (ipAddress == null || ipAddress.length() == 0 || "unknown".equalsIgnoreCase(ipAddress)) {
                ipAddress = request.getHeader("WL-Proxy-Client-IP");
            }
            if (ipAddress == null || ipAddress.length() == 0 || "unknown".equalsIgnoreCase(ipAddress)) {
                ipAddress = request.getRemoteAddr();
            }
            if (ipAddress != null && ipAddress.length() > 15 && ipAddress.indexOf(",") > 0) {
                ipAddress = ipAddress.substring(0, ipAddress.indexOf(","));
            }
        }
        catch (Exception e) {
            ipAddress = "";
        }
        return ipAddress;
    }
}

