package cn.com.duiba.spring.boot.starter.dsp.sampler;

import cn.com.duiba.spring.boot.starter.dsp.sampler.handler.ApolloPanGuHandler;
import cn.hutool.core.lang.UUID;
import com.alibaba.ttl.TransmittableThreadLocal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import java.util.Objects;
import java.util.Random;

public class SamplerLog {

    private static final Logger logger = LoggerFactory.getLogger(SamplerLog.class);

    private static final TransmittableThreadLocal<String> LOCAL = new TransmittableThreadLocal<>();

    private static final Random random = new Random();

    @Resource
    private ApolloPanGuHandler apolloPanGuHandler;

    private static SamplerLog samplerLog;

    public static void start(String type, String value) {
        Integer sampling = samplerLog.apolloPanGuHandler.getSampling(type, value);
        if (random.nextInt(sampling) == 0) {
            LOCAL.set(UUID.randomUUID().toString(true));
        }
    }

    public static void info(String format, Object... arguments) {
        try {
            if (infoFlag()) {
                logger.info("samplingId-" + LOCAL.get() + "," + format, arguments);
            }
        } catch (Exception e) {
            logger.warn("SamplerLog info error", e);
        }
    }

    public static void end() {
        LOCAL.remove();
    }

    public static String getSamplerId() {
        return LOCAL.get();
    }

    public static void setSamplerId(String samplerId) {
        LOCAL.set(samplerId);
    }

    public static boolean infoFlag() {
        return Objects.nonNull(LOCAL.get());
    }

    @PostConstruct
    public void init() {
        samplerLog = this;
    }
}
