package cn.com.duiba.spring.boot.starter.dsp.sampler.feign;

import cn.com.duiba.spring.boot.starter.dsp.sampler.SamplerLog;
import cn.com.duiba.spring.boot.starter.dsp.sampler.constants.SamplerLogConstant;
import feign.RequestInterceptor;
import feign.RequestTemplate;
import lombok.extern.slf4j.Slf4j;

@Slf4j
public class CustomRequestInterceptor implements RequestInterceptor {

    @Override
    public void apply(RequestTemplate template) {
        if (!SamplerLog.infoFlag()) {
            return;
        }
        template.header(SamplerLogConstant.RPC_SAMPLING_ID, SamplerLog.getSamplerId());
    }

}
