/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.spring.boot.starter.dsp.sampler;

import cn.com.duiba.spring.boot.starter.dsp.sampler.constants.SamplerLogProperties;
import cn.com.duiba.spring.boot.starter.dsp.sampler.converter.SamplerLogConverter;
import cn.hutool.core.lang.UUID;
import com.alibaba.ttl.TransmittableThreadLocal;
import java.util.Objects;
import java.util.Random;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.context.config.annotation.RefreshScope;

@RefreshScope
public class SamplerLog {
    private static final Logger logger = LoggerFactory.getLogger(SamplerLog.class);
    private static final TransmittableThreadLocal<String> LOCAL = new TransmittableThreadLocal();
    private static final Random random = new Random();
    @Resource
    private SamplerLogConverter samplerLogConverter;
    @Resource
    private SamplerLogProperties samplerLogProperties;
    private static SamplerLog samplerLog;

    public static void start(String type, String value) {
        if (SamplerLog.infoFlag()) {
            return;
        }
        Integer sampling = SamplerLog.samplerLog.samplerLogConverter.getSampling(type, value);
        Integer n = sampling = sampling == null ? SamplerLog.samplerLog.samplerLogProperties.getDefaultSize() : sampling;
        if (sampling == 0) {
            return;
        }
        if (random.nextInt(sampling) == 0) {
            LOCAL.set((Object)UUID.randomUUID().toString(true));
        }
    }

    public static void start() {
        if (SamplerLog.infoFlag()) {
            return;
        }
        if (random.nextInt(SamplerLog.samplerLog.samplerLogProperties.getDefaultSize()) == 0) {
            LOCAL.set((Object)UUID.randomUUID().toString(true));
        }
    }

    public static void info(String format, Object ... arguments) {
        try {
            if (SamplerLog.infoFlag()) {
                String result = String.format(format, arguments);
                if (result.length() > 150000) {
                    logger.info("vv 150000 log message is {}", (Object)result.substring(0, 200));
                    return;
                }
                logger.info("samplingId-" + (String)LOCAL.get() + "," + format, arguments);
            }
        }
        catch (Exception e) {
            logger.warn("SamplerLog info error", (Throwable)e);
        }
    }

    public static void info(boolean fullFlag, String format, Object ... arguments) {
        if (fullFlag) {
            logger.info(format, arguments);
            return;
        }
        SamplerLog.info(format, arguments);
    }

    public static void warn(String format, Object ... arguments) {
        try {
            if (SamplerLog.infoFlag()) {
                String result = String.format(format, arguments);
                if (result.length() > 150000) {
                    logger.info("vv 150000 log message is {}", (Object)result.substring(0, 200));
                    return;
                }
                logger.warn("samplingId-" + (String)LOCAL.get() + "," + format, arguments);
            }
        }
        catch (Exception e) {
            logger.warn("SamplerLog info error", (Throwable)e);
        }
    }

    public static void warn(boolean fullFlag, String format, Object ... arguments) {
        if (fullFlag) {
            logger.warn(format, arguments);
            return;
        }
        SamplerLog.warn(format, arguments);
    }

    public static void end() {
        LOCAL.remove();
    }

    public static String getSamplerId() {
        return (String)LOCAL.get();
    }

    public static void setSamplerId(String samplerId) {
        LOCAL.set((Object)samplerId);
    }

    public static boolean infoFlag() {
        return Objects.nonNull(LOCAL.get());
    }

    @PostConstruct
    public void init() {
        samplerLog = this;
    }
}

