package cn.com.duiba.spring.boot.starter.dsp.sampler.filter;

import cn.com.duiba.spring.boot.starter.dsp.sampler.SamplerLog;
import cn.com.duiba.spring.boot.starter.dsp.sampler.constants.SamplerLogConstant;
import org.apache.commons.lang3.StringUtils;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.constants.CommonConstants;
import org.apache.dubbo.common.extension.Activate;
import org.apache.dubbo.rpc.*;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.Objects;

@Activate(group = {CommonConstants.CONSUMER, CommonConstants.PROVIDER}, order = -2000)
public class DubboLogSamplerContextFilter implements Filter {

    private static final Logger logger = LoggerFactory.getLogger(DubboLogSamplerContextFilter.class);

    @Override
    public Result invoke(Invoker<?> invoker, Invocation invocation) throws RpcException {
        URL url = invoker.getUrl();
        String sideKey = url.getParameter("side");
        boolean isConsumerSide = Objects.equals(sideKey, CommonConstants.CONSUMER);

        // 1、判断是消费者还是服务提供者
        if (isConsumerSide && StringUtils.isNotBlank(SamplerLog.getSamplerId())) {
            // 如果是消费者，将打印日志标识符set至上下文中

            RpcContext.getContext().setAttachment(SamplerLogConstant.DUBBO_SAMPLING_ID, SamplerLog.getSamplerId());
        } else {
            // 如果是服务提供者，从上下文取出
            String samplingId = RpcContext.getContext().getAttachment(SamplerLogConstant.DUBBO_SAMPLING_ID);
            SamplerLog.setSamplerId(samplingId);
        }

        try {
            return invoker.invoke(invocation);
        } finally {
            if (SamplerLog.infoFlag()){
                SamplerLog.end();
            }
        }



    }

}
